import json
import httpx
import random
import time
from datetime import datetime

key = '0x4AAAAAAAAjq6WYeRDKmebM'

def parse_cf_params(domain, siteKey, client=httpx.Client()):
    rep = client.get(domain)
    d = rep.text.split(':')
    ray = rep.headers['CF-RAY'].split('-')[0]
    #for i,v in enumerate(d):
    #    print(i, v)

    rep2 = client.get(f'https://challenges.cloudflare.com/cdn-cgi/challenge-platform/h/b/turnstile/if/ov2/av0/rcv0/0/auvka/{siteKey}/dark/fbE/normal/auto/')
    b = rep2.text.split(': ')
    return d, b, ray

def repeat_func(value='window.frameElement', c=11):
    _data = []
    for i in range(c):
        _data.append(value)
    return _data


CF_CHALLENGE_LANG = {
    1: 'en-US',
    2: ['es-US', 'es-419', 'es'],
    3: ['en-MX'],
    4: 'es-es'
}


class CF_Interactive:
    def cf1_flow_data(params, ass_param_name=None, ass_param_name2=None):
        return {
            "Iotan0": params[31].split("'")[1],
            "cxlU8": params[32].split("'")[1],
            "OfLv3": "3",
            "kipPH4": 0,
            "LxrEk8": 0,
            "kAUw0": random.uniform(10, 300),
            "lETW7": random.uniform(10, 200),
            "nbVnE1": 1,
            "ZhtLK5": {
                "ru": params[48].split("'")[1],
                "ra": params[49].split("'")[1],
                "d": params[50].split("'")[1],
                "t": params[51].split("'")[1],
                "cT": round(time.time()),
                "m": params[53].split("'")[1],
                "i1": params[54].split("'")[1],
                "i2": params[55].split("'")[1],
                "zh": params[56].split("'")[1],
                "uh": params[57].split("'")[1],
                "hh": params[58].split("'")[1]
            },
            "PZKL0": {
                "dYjR8": 0, "QEey2": 0,
                "pARx5": 0, "wDQcp4": 0,
                "LkpZG2": 0, "dhbx1": 0,
                "wZkEO6": 0, "LLtC8": 0
            },
            "rKjPv7": False,
            "pqdN8": False,
            "coao1": ass_param_name,
            "bacv6": "",
            "FnNf4": repeat_func(),
            "XBVsN3": 0,
            "MEuBS5": ass_param_name2
        }

    def cf2_flow_data(
        params, 
        cf_ray, 
        siteKey, 
        ass_param, 
        ass_param2, 
        is_this_a_key="62ec4f065604"
    ):
        # i hate cloudflare params
    
        return {
            "Iotan0": "chl_api_m",
            "cxlU8": params[16].split("'")[1],
            "OfLv3": "3",
            "kipPH4": 0,
            "LxrEk8": 0,
            "kAUw0": random.uniform(100, 300),
            "lETW7": random.uniform(20, 150),
            "nbVnE1": 1,
            "ZhtLK5": {
                "ru": params[27].split("'")[1],
                "ra": params[28].split("'")[1],
                "d": params[29].split("'")[1],
                "t": params[30].split("'")[1],
                "m": params[31].split("'")[1],
                "i1": params[32].split("'")[1],
                "i2": params[33].split("'")[1],
                "uh": params[34].split("'")[1],
                "hh": params[35].split("'")[1],
                "zh": params[36].split("'")[1],
            },
            "PZKL0": {
                "dYjR8": 0, "QEey2": 0,
                "pARx5": 0, "wDQcp4": 0,
                "LkpZG2": 0, "dhbx1": 0,
                "wZkEO6": 0, "LLtC8": 0
            },
            "coao1": ass_param,
            "bacv6": "",
            "FnNf4": repeat_func(c=2),
            "XBVsN3": 0,
            "MEuBS5": ass_param2,
            "VXEb2": "0",
            "ESpj2": siteKey,
            "qBkvc8": "interactive",
            "wETrQ4": cf_ray,
            "NrYV5": "3gAFo2l2MbhHVGxJaThWMmJzQVBMNVllREpvT3JRPT2jaXYyuEY4U3JvREVKZmgrRnQwQmdSaFBXZlE9PaFk2gGYbTd6anNaWVVwbDdpVzFBNHh1RkZWWlVwTnFYcEdSSjg3OTFGTjErQm13V0VZUzdTNkI5SjZkNnN5UzlzRHVXVXdYZm5WTUVTdmN1MGpzUmVQS0laRnBJOVVwZmtjMzh2QnhROCtrSkZETTQycVdSM09mSDBpVUFaWFNaSHhyeGJTN0pMMnJzQ3pyRHBKa1VvODBpcFI4a3NST2U3d3l5Sk1mRHFnUmY2SU9aaFlPcWFRZHFBM3J3UUU0dU43eWZMajJqQjhqUnhqcTBCVlpVSFpMcDNYOGpPVFVyRW9LRG9ZM0ZYQ3Z2TGlUWUlHNUZWTE43ZUx0REV5SHhneGZXUHhFVUlIOEplOHNzUk5kaTZ5TFcwSmpqNld2T1d2TVBReFFSQjkzWmxxa0pOOEtDdGlieHp0ZERodTZkRFFTUFdDREUwUGtvVkNyMCtzNDdSeUE5Rk9Dbnp1SEVia04vWlRjaE1zczhyVmEweHRNcCtoSDdJZ256cEliTm9uMDI2alFrSHRCSlVIK1JHaEZGelJaMkVFZz09oW3ZLGdsaXJGekZpdzExcjNxTVlCZnFQN01CZ3lLdnVaQ0IvWVlkbTFoRHBsSnM9oXS0TVRjeU9USTJPRE0yTWk0d09Eaz0=",
            "RnkWM0": 0,
            "goWbN7": is_this_a_key,
            "OKUJ7": f"https://challenges.cloudflare.com/turnstile/v0/b/{is_this_a_key}/api.js?onload=DXjyL6&render=explicit",
            "MBlJ0": "https://nopecha.com/demo/cloudflare",
            "wueX2": "https://nopecha.com",
            "itebZ1": params[10].split("'")[1],
            "cZmt6": random.uniform(1000, 4000),
            "RMiRU4": random.uniform(1000, 4000),
            "svKw7": 0,
            "jgvf6": 0,
            "rsZM5": random.uniform(1000, 4000),
            "tjTLZ1": 0,
            "cobF5": random.uniform(1, 10),
            "huON7": random.uniform(50, 500),
            "jASY4": random.uniform(50, 500),
            "fmoBu7": random.uniform(5, 100)
        }
        
    def cf3_flow_data(
        params,
        domain,
        cf_ray, 
        siteKey, 
        ass_param,
        flow_url,
        is_this_a_key="62ec4f065604",
        user_agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36'
    ):
        return {
            "1": {
                "bXDBI2": "E2w2w77Cm8KhwrBK",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": random.randint(2200, 2900),
                "ErFO3": 3,
                "QyECW7": {
                    "0": [
                        "length",
                        "innerWidth",
                        "innerHeight",
                        "scrollX",
                        "pageXOffset",
                        "scrollY",
                        "pageYOffset",
                        "screenX",
                        "screenY",
                        "screenLeft",
                        "screenTop",
                        "orientation",
                        "TEMPORARY",
                        "d.softNavigations",
                        "s.availLeft",
                        "s.availTop",
                        "so.angle",
                        "o.MEuBS5",
                    ],
                    "1": [
                        "PERSISTENT",
                        "d.childElementCount",
                        "d.ELEMENT_NODE",
                        "d.DOCUMENT_POSITION_DISCONNECTED",
                    ],
                    "2": [
                        "n.maxTouchPoints",
                        "n.deviceMemory",
                        "d.ATTRIBUTE_NODE",
                        "d.DOCUMENT_POSITION_PRECEDING",
                    ],
                    "3": ["d.TEXT_NODE"],
                    "4": ["d.CDATA_SECTION_NODE", "d.DOCUMENT_POSITION_FOLLOWING"],
                    "5": ["d.ENTITY_REFERENCE_NODE"],
                    "6": ["d.ENTITY_NODE"],
                    "7": ["d.PROCESSING_INSTRUCTION_NODE"],
                    "8": [
                        "n.hardwareConcurrency",
                        "d.COMMENT_NODE",
                        "d.DOCUMENT_POSITION_CONTAINS",
                    ],
                    "9": ["d.nodeType", "d.DOCUMENT_NODE"],
                    "10": ["d.DOCUMENT_TYPE_NODE"],
                    "11": ["d.DOCUMENT_FRAGMENT_NODE"],
                    "12": ["d.NOTATION_NODE"],
                    "16": ["d.DOCUMENT_POSITION_CONTAINED_BY"],
                    "24": ["s.colorDepth", "s.pixelDepth"],
                    "32": ["d.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC"],
                    "65": ["o.innerHeight"],
                    "300": ["o.innerWidth"],
                    "444": ["outerWidth", "s.availWidth", "s.width"],
                    "853": ["outerHeight"],
                    "985": ["s.availHeight", "s.height"],
                    "o": [
                        "window",
                        "self",
                        "document",
                        "location",
                        "customElements",
                        "history",
                        "navigation",
                        "locationbar",
                        "menubar",
                        "personalbar",
                        "scrollbars",
                        "statusbar",
                        "toolbar",
                        "frames",
                        "top",
                        "parent",
                        "frameElement",
                        "navigator",
                        "external",
                        "screen",
                        "visualViewport",
                        "clientInformation",
                        "styleMedia",
                        "trustedTypes",
                        "performance",
                        "crypto",
                        "indexedDB",
                        "sessionStorage",
                        "localStorage",
                        "scheduler",
                        "speechSynthesis",
                        "chrome",
                        "caches",
                        "cookieStore",
                        "launchQueue",
                        "privateAttribution",
                        "globalThis",
                        "JSON",
                        "Math",
                        "Intl",
                        "Atomics",
                        "Reflect",
                        "console",
                        "CSS",
                        "WebAssembly",
                        "GPUBufferUsage",
                        "GPUColorWrite",
                        "GPUMapMode",
                        "GPUShaderStage",
                        "GPUTextureUsage",
                        "n.scheduling",
                        "n.userActivation",
                        "n.geolocation",
                        "n.connection",
                        "n.plugins",
                        "n.mimeTypes",
                        "n.webkitTemporaryStorage",
                        "n.webkitPersistentStorage",
                        "n.bluetooth",
                        "n.storageBuckets",
                        "n.clipboard",
                        "n.credentials",
                        "n.keyboard",
                        "n.managed",
                        "n.mediaDevices",
                        "n.storage",
                        "n.serviceWorker",
                        "n.virtualKeyboard",
                        "n.wakeLock",
                        "n.contacts",
                        "n.ink",
                        "n.devicePosture",
                        "n.locks",
                        "n.mediaCapabilities",
                        "n.mediaSession",
                        "n.ml",
                        "n.permissions",
                        "n.presentation",
                        "n.gpu",
                        "n.usb",
                        "n.xr",
                        "n.userAgentData",
                        "d.location",
                        "d.implementation",
                        "d.documentElement",
                        "d.body",
                        "d.head",
                        "d.images",
                        "d.embeds",
                        "d.plugins",
                        "d.links",
                        "d.forms",
                        "d.scripts",
                        "d.defaultView",
                        "d.anchors",
                        "d.applets",
                        "d.scrollingElement",
                        "d.featurePolicy",
                        "d.children",
                        "d.firstElementChild",
                        "d.lastElementChild",
                        "d.activeElement",
                        "d.styleSheets",
                        "d.fonts",
                        "d.timeline",
                        "d.fragmentDirective",
                        "d.childNodes",
                        "d.firstChild",
                        "d.lastChild",
                        "s.orientation",
                        "o.angular",
                        "o.event",
                    ],
                    "F": [
                        "closed",
                        "credentialless",
                        "n.pdfViewerEnabled",
                        "n.webdriver",
                        "d.xmlStandalone",
                        "d.wasDiscarded",
                        "d.prerendering",
                        "d.fullscreen",
                        "d.webkitIsFullScreen",
                        "s.isExtended",
                    ],
                    "x": [
                        "opener",
                        "onsearch",
                        "onappinstalled",
                        "onbeforeinstallprompt",
                        "onbeforexrselect",
                        "onabort",
                        "onbeforeinput",
                        "onblur",
                        "oncancel",
                        "oncanplay",
                        "oncanplaythrough",
                        "onchange",
                        "onclick",
                        "onclose",
                        "oncontextlost",
                        "oncontextmenu",
                        "oncontextrestored",
                        "oncuechange",
                        "ondblclick",
                        "ondrag",
                        "ondragend",
                        "ondragenter",
                        "ondragleave",
                        "ondragover",
                        "ondragstart",
                        "ondrop",
                        "ondurationchange",
                        "onemptied",
                        "onended",
                        "onerror",
                        "onfocus",
                        "onformdata",
                        "oninput",
                        "oninvalid",
                        "onkeydown",
                        "onkeypress",
                        "onkeyup",
                        "onload",
                        "onloadeddata",
                        "onloadedmetadata",
                        "onloadstart",
                        "onmousedown",
                        "onmouseenter",
                        "onmouseleave",
                        "onmousemove",
                        "onmouseout",
                        "onmouseover",
                        "onmouseup",
                        "onmousewheel",
                        "onpause",
                        "onplay",
                        "onplaying",
                        "onprogress",
                        "onratechange",
                        "onreset",
                        "onresize",
                        "onscroll",
                        "onsecuritypolicyviolation",
                        "onseeked",
                        "onseeking",
                        "onselect",
                        "onslotchange",
                        "onstalled",
                        "onsubmit",
                        "onsuspend",
                        "ontimeupdate",
                        "ontoggle",
                        "onvolumechange",
                        "onwaiting",
                        "onwebkitanimationend",
                        "onwebkitanimationiteration",
                        "onwebkitanimationstart",
                        "onwebkittransitionend",
                        "onwheel",
                        "onauxclick",
                        "ongotpointercapture",
                        "onlostpointercapture",
                        "onpointerdown",
                        "onpointermove",
                        "onpointerrawupdate",
                        "onpointerup",
                        "onpointercancel",
                        "onpointerover",
                        "onpointerout",
                        "onpointerenter",
                        "onpointerleave",
                        "onselectstart",
                        "onselectionchange",
                        "onanimationend",
                        "onanimationiteration",
                        "onanimationstart",
                        "ontransitionrun",
                        "ontransitionstart",
                        "ontransitionend",
                        "ontransitioncancel",
                        "onafterprint",
                        "onbeforeprint",
                        "onbeforeunload",
                        "onhashchange",
                        "onlanguagechange",
                        "onmessage",
                        "onmessageerror",
                        "onoffline",
                        "ononline",
                        "onpagehide",
                        "onpageshow",
                        "onpopstate",
                        "onrejectionhandled",
                        "onstorage",
                        "onunhandledrejection",
                        "onunload",
                        "onorientationchange",
                        "oncontentvisibilityautostatechange",
                        "onoverscroll",
                        "onscrollend",
                        "ontimezonechange",
                        "ondevicemotion",
                        "ondeviceorientation",
                        "ondeviceorientationabsolute",
                        "onbeforematch",
                        "onbeforetoggle",
                        "ontouchcancel",
                        "ontouchend",
                        "ontouchmove",
                        "ontouchstart",
                        "n.doNotTrack",
                        "d.doctype",
                        "d.xmlEncoding",
                        "d.xmlVersion",
                        "d.currentScript",
                        "d.onreadystatechange",
                        "d.all",
                        "d.onpointerlockchange",
                        "d.onpointerlockerror",
                        "d.onbeforecopy",
                        "d.onbeforecut",
                        "d.onbeforepaste",
                        "d.onfreeze",
                        "d.onprerenderingchange",
                        "d.onresume",
                        "d.onsearch",
                        "d.onvisibilitychange",
                        "d.onfullscreenchange",
                        "d.onfullscreenerror",
                        "d.webkitCurrentFullScreenElement",
                        "d.webkitFullscreenElement",
                        "d.onwebkitfullscreenchange",
                        "d.onwebkitfullscreenerror",
                        "d.rootElement",
                        "d.onbeforexrselect",
                        "d.onabort",
                        "d.onbeforeinput",
                        "d.onblur",
                        "d.oncancel",
                        "d.oncanplay",
                        "d.oncanplaythrough",
                        "d.onchange",
                        "d.onclick",
                        "d.onclose",
                        "d.oncontextlost",
                        "d.oncontextmenu",
                        "d.oncontextrestored",
                        "d.oncuechange",
                        "d.ondblclick",
                        "d.ondrag",
                        "d.ondragend",
                        "d.ondragenter",
                        "d.ondragleave",
                        "d.ondragover",
                        "d.ondragstart",
                        "d.ondrop",
                        "d.ondurationchange",
                        "d.onemptied",
                        "d.onended",
                        "d.onerror",
                        "d.onfocus",
                        "d.onformdata",
                        "d.oninput",
                        "d.oninvalid",
                        "d.onkeydown",
                        "d.onkeypress",
                        "d.onkeyup",
                        "d.onload",
                        "d.onloadeddata",
                        "d.onloadedmetadata",
                        "d.onloadstart",
                        "d.onmousedown",
                        "d.onmouseenter",
                        "d.onmouseleave",
                        "d.onmousemove",
                        "d.onmouseout",
                        "d.onmouseover",
                        "d.onmouseup",
                        "d.onmousewheel",
                        "d.onpause",
                        "d.onplay",
                        "d.onplaying",
                        "d.onprogress",
                        "d.onratechange",
                        "d.onreset",
                        "d.onresize",
                        "d.onscroll",
                        "d.onsecuritypolicyviolation",
                        "d.onseeked",
                        "d.onseeking",
                        "d.onselect",
                        "d.onslotchange",
                        "d.onstalled",
                        "d.onsubmit",
                        "d.onsuspend",
                        "d.ontimeupdate",
                        "d.ontoggle",
                        "d.onvolumechange",
                        "d.onwaiting",
                        "d.onwebkitanimationend",
                        "d.onwebkitanimationiteration",
                        "d.onwebkitanimationstart",
                        "d.onwebkittransitionend",
                        "d.onwheel",
                        "d.onauxclick",
                        "d.ongotpointercapture",
                        "d.onlostpointercapture",
                        "d.onpointerdown",
                        "d.onpointermove",
                        "d.onpointerrawupdate",
                        "d.onpointerup",
                        "d.onpointercancel",
                        "d.onpointerover",
                        "d.onpointerout",
                        "d.onpointerenter",
                        "d.onpointerleave",
                        "d.onselectstart",
                        "d.onselectionchange",
                        "d.onanimationend",
                        "d.onanimationiteration",
                        "d.onanimationstart",
                        "d.ontransitionrun",
                        "d.ontransitionstart",
                        "d.ontransitionend",
                        "d.ontransitioncancel",
                        "d.oncopy",
                        "d.oncut",
                        "d.onpaste",
                        "d.pointerLockElement",
                        "d.fullscreenElement",
                        "d.pictureInPictureElement",
                        "d.oncontentvisibilityautostatechange",
                        "d.onoverscroll",
                        "d.onscrollend",
                        "d.onbeforematch",
                        "d.onbeforetoggle",
                        "d.ontouchcancel",
                        "d.ontouchend",
                        "d.ontouchmove",
                        "d.ontouchstart",
                        "d.ownerDocument",
                        "d.parentNode",
                        "d.parentElement",
                        "d.previousSibling",
                        "d.nextSibling",
                        "d.nodeValue",
                        "d.textContent",
                        "s.onchange",
                        "so.onchange",
                    ],
                    "https://challenges.cloudflare.com": ["origin"],
                    "1.5754061937332153": ["devicePixelRatio"],
                    "T": [
                        "isSecureContext",
                        "crossOriginIsolated",
                        "originAgentCluster",
                        "offscreenBuffering",
                        "n.cookieEnabled",
                        "n.onLine",
                        "d.hidden",
                        "d.webkitHidden",
                        "d.fullscreenEnabled",
                        "d.webkitFullscreenEnabled",
                        "d.pictureInPictureEnabled",
                        "d.isConnected",
                    ],
                    "N": [
                        "alert",
                        "atob",
                        "blur",
                        "btoa",
                        "cancelAnimationFrame",
                        "cancelIdleCallback",
                        "captureEvents",
                        "clearInterval",
                        "clearTimeout",
                        "close",
                        "confirm",
                        "createImageBitmap",
                        "fetch",
                        "find",
                        "focus",
                        "getComputedStyle",
                        "getSelection",
                        "matchMedia",
                        "moveBy",
                        "moveTo",
                        "open",
                        "postMessage",
                        "print",
                        "prompt",
                        "queueMicrotask",
                        "releaseEvents",
                        "reportError",
                        "requestAnimationFrame",
                        "requestIdleCallback",
                        "resizeBy",
                        "resizeTo",
                        "scroll",
                        "scrollBy",
                        "scrollTo",
                        "setInterval",
                        "setTimeout",
                        "stop",
                        "structuredClone",
                        "webkitCancelAnimationFrame",
                        "webkitRequestAnimationFrame",
                        "getComputedAccessibleNode",
                        "openDatabase",
                        "webkitRequestFileSystem",
                        "webkitResolveLocalFileSystemURL",
                        "getDigitalGoodsService",
                        "getLockScreenData",
                        "getScreenDetails",
                        "addEventListener",
                        "dispatchEvent",
                        "removeEventListener",
                        "Object",
                        "Function",
                        "Number",
                        "parseFloat",
                        "parseInt",
                        "Boolean",
                        "String",
                        "Symbol",
                        "Date",
                        "Promise",
                        "RegExp",
                        "Error",
                        "AggregateError",
                        "EvalError",
                        "RangeError",
                        "ReferenceError",
                        "SyntaxError",
                        "TypeError",
                        "URIError",
                        "ArrayBuffer",
                        "Uint8Array",
                        "Int8Array",
                        "Uint16Array",
                        "Int16Array",
                        "Uint32Array",
                        "Int32Array",
                        "Float32Array",
                        "Float64Array",
                        "Uint8ClampedArray",
                        "BigUint64Array",
                        "BigInt64Array",
                        "DataView",
                        "Map",
                        "BigInt",
                        "Set",
                        "WeakMap",
                        "WeakSet",
                        "Proxy",
                        "FinalizationRegistry",
                        "WeakRef",
                        "decodeURI",
                        "decodeURIComponent",
                        "encodeURI",
                        "encodeURIComponent",
                        "escape",
                        "unescape",
                        "eval",
                        "isFinite",
                        "isNaN",
                        "webkitSpeechRecognitionEvent",
                        "webkitSpeechRecognitionError",
                        "webkitSpeechRecognition",
                        "webkitSpeechGrammarList",
                        "webkitSpeechGrammar",
                        "WebSocketStream",
                        "VisibilityStateEntry",
                        "ViewTransition",
                        "VideoPlaybackQuality",
                        "VTTRegion",
                        "TrackDefaultList",
                        "TrackDefault",
                        "SpeechSynthesisUtterance",
                        "SpeechSynthesisEvent",
                        "SpeechSynthesisErrorEvent",
                        "ViewTimeline",
                        "ScrollTimeline",
                        "RemotePlayback",
                        "PushSubscriptionOptions",
                        "PushSubscription",
                        "PushManager",
                        "Permissions",
                        "PermissionStatus",
                        "PeriodicSyncManager",
                        "PaymentRequestUpdateEvent",
                        "PaymentManager",
                        "OverscrollEvent",
                        "Notification",
                        "NavigatorUAData",
                        "MutationEvent",
                        "MediaSession",
                        "MediaMetadata",
                        "MathMLElement",
                        "MLModelLoader",
                        "ML",
                        "HighlightRegistry",
                        "Highlight",
                        "HTMLSelectMenuElement",
                        "GamepadButtonEvent",
                        "GamepadAxisEvent",
                        "FormattedText",
                        "TextDirective",
                        "SelectorDirective",
                        "Directive",
                        "Ink",
                        "DelegatedInkTrailPresenter",
                        "ContentVisibilityAutoStateChangeEvent",
                        "ContentIndex",
                        "PartRoot",
                        "Part",
                        "NodePart",
                        "DocumentPartRoot",
                        "ChildNodePart",
                        "CanvasFilter",
                        "CSSToggleMap",
                        "CSSToggleEvent",
                        "CSSToggle",
                        "CSSStartingStyleRule",
                        "CSSScopeRule",
                        "CSSTryRule",
                        "CSSPositionFallbackRule",
                        "CSSRGB",
                        "CSSHWB",
                        "CSSHSL",
                        "CSSColorValue",
                        "BluetoothUUID",
                        "BeforeCreatePolicyEvent",
                        "BackgroundFetchRegistration",
                        "BackgroundFetchRecord",
                        "BackgroundFetchManager",
                        "VideoTrackList",
                        "VideoTrack",
                        "AudioTrackList",
                        "AudioTrack",
                        "DocumentTimeline",
                        "CSSTransition",
                        "CSSAnimation",
                        "AnimationTimeline",
                        "AnimationPlaybackEvent",
                        "ComputedAccessibleNode",
                        "AccessibleNodeList",
                        "AccessibleNode",
                        "Option",
                        "Image",
                        "Audio",
                        "webkitURL",
                        "webkitRTCPeerConnection",
                        "webkitMediaStream",
                        "WebKitMutationObserver",
                        "WebKitCSSMatrix",
                        "XSLTProcessor",
                        "XPathResult",
                        "XPathExpression",
                        "XPathEvaluator",
                        "XMLSerializer",
                        "XMLHttpRequestUpload",
                        "XMLHttpRequestEventTarget",
                        "XMLHttpRequest",
                        "XMLDocument",
                        "WritableStreamDefaultWriter",
                        "WritableStreamDefaultController",
                        "WritableStream",
                        "Worker",
                        "Window",
                        "WheelEvent",
                        "WebSocket",
                        "WebGLVertexArrayObject",
                        "WebGLUniformLocation",
                        "WebGLTransformFeedback",
                        "WebGLTexture",
                        "WebGLSync",
                        "WebGLShaderPrecisionFormat",
                        "WebGLShader",
                        "WebGLSampler",
                        "WebGLRenderingContext",
                        "WebGLRenderbuffer",
                        "WebGLQuery",
                        "WebGLProgram",
                        "WebGLFramebuffer",
                        "WebGLContextEvent",
                        "WebGLBuffer",
                        "WebGLActiveInfo",
                        "WebGL2RenderingContext",
                        "WaveShaperNode",
                        "VisualViewport",
                        "VirtualKeyboardGeometryChangeEvent",
                        "ValidityState",
                        "VTTCue",
                        "UserActivation",
                        "URLSearchParams",
                        "URLPattern",
                        "URL",
                        "UIEvent",
                        "TrustedTypePolicyFactory",
                        "TrustedTypePolicy",
                        "TrustedScriptURL",
                        "TrustedScript",
                        "TrustedHTML",
                        "TreeWalker",
                        "TransitionEvent",
                        "TransformStreamDefaultController",
                        "TransformStream",
                        "TrackEvent",
                        "TouchList",
                        "TouchEvent",
                        "Touch",
                        "TimeRanges",
                        "TextTrackList",
                        "TextTrackCueList",
                        "TextTrackCue",
                        "TextTrack",
                        "TextMetrics",
                        "TextEvent",
                        "TextEncoderStream",
                        "TextEncoder",
                        "TextDecoderStream",
                        "TextDecoder",
                        "Text",
                        "TaskSignal",
                        "TaskPriorityChangeEvent",
                        "TaskController",
                        "TaskAttributionTiming",
                        "SyncManager",
                        "SubmitEvent",
                        "StyleSheetList",
                        "StyleSheet",
                        "StylePropertyMapReadOnly",
                        "StylePropertyMap",
                        "StorageEvent",
                        "Storage",
                        "StereoPannerNode",
                        "StaticRange",
                        "SourceBufferList",
                        "SourceBuffer",
                        "ShadowRoot",
                        "Selection",
                        "SecurityPolicyViolationEvent",
                        "ScriptProcessorNode",
                        "ScreenOrientation",
                        "Screen",
                        "Scheduling",
                        "Scheduler",
                        "SVGViewElement",
                        "SVGUseElement",
                        "SVGUnitTypes",
                        "SVGTransformList",
                        "SVGTransform",
                        "SVGTitleElement",
                        "SVGTextPositioningElement",
                        "SVGTextPathElement",
                        "SVGTextElement",
                        "SVGTextContentElement",
                        "SVGTSpanElement",
                        "SVGSymbolElement",
                        "SVGSwitchElement",
                        "SVGStyleElement",
                        "SVGStringList",
                        "SVGStopElement",
                        "SVGSetElement",
                        "SVGScriptElement",
                        "SVGSVGElement",
                        "SVGRectElement",
                        "SVGRect",
                        "SVGRadialGradientElement",
                        "SVGPreserveAspectRatio",
                        "SVGPolylineElement",
                        "SVGPolygonElement",
                        "SVGPointList",
                        "SVGPoint",
                        "SVGPatternElement",
                        "SVGPathElement",
                        "SVGNumberList",
                        "SVGNumber",
                        "SVGMetadataElement",
                        "SVGMatrix",
                        "SVGMaskElement",
                        "SVGMarkerElement",
                        "SVGMPathElement",
                        "SVGLinearGradientElement",
                        "SVGLineElement",
                        "SVGLengthList",
                        "SVGLength",
                        "SVGImageElement",
                        "SVGGraphicsElement",
                        "SVGGradientElement",
                        "SVGGeometryElement",
                        "SVGGElement",
                        "SVGForeignObjectElement",
                        "SVGFilterElement",
                        "SVGFETurbulenceElement",
                        "SVGFETileElement",
                        "SVGFESpotLightElement",
                        "SVGFESpecularLightingElement",
                        "SVGFEPointLightElement",
                        "SVGFEOffsetElement",
                        "SVGFEMorphologyElement",
                        "SVGFEMergeNodeElement",
                        "SVGFEMergeElement",
                        "SVGFEImageElement",
                        "SVGFEGaussianBlurElement",
                        "SVGFEFuncRElement",
                        "SVGFEFuncGElement",
                        "SVGFEFuncBElement",
                        "SVGFEFuncAElement",
                        "SVGFEFloodElement",
                        "SVGFEDropShadowElement",
                        "SVGFEDistantLightElement",
                        "SVGFEDisplacementMapElement",
                        "SVGFEDiffuseLightingElement",
                        "SVGFEConvolveMatrixElement",
                        "SVGFECompositeElement",
                        "SVGFEComponentTransferElement",
                        "SVGFEColorMatrixElement",
                        "SVGFEBlendElement",
                        "SVGEllipseElement",
                        "SVGElement",
                        "SVGDescElement",
                        "SVGDefsElement",
                        "SVGComponentTransferFunctionElement",
                        "SVGClipPathElement",
                        "SVGCircleElement",
                        "SVGAnimationElement",
                        "SVGAnimatedTransformList",
                        "SVGAnimatedString",
                        "SVGAnimatedRect",
                        "SVGAnimatedPreserveAspectRatio",
                        "SVGAnimatedNumberList",
                        "SVGAnimatedNumber",
                        "SVGAnimatedLengthList",
                        "SVGAnimatedLength",
                        "SVGAnimatedInteger",
                        "SVGAnimatedEnumeration",
                        "SVGAnimatedBoolean",
                        "SVGAnimatedAngle",
                        "SVGAnimateTransformElement",
                        "SVGAnimateMotionElement",
                        "SVGAnimateElement",
                        "SVGAngle",
                        "SVGAElement",
                        "Response",
                        "ResizeObserverSize",
                        "ResizeObserverEntry",
                        "ResizeObserver",
                        "Request",
                        "ReportingObserver",
                        "ReadableStreamDefaultReader",
                        "ReadableStreamDefaultController",
                        "ReadableStreamBYOBRequest",
                        "ReadableStreamBYOBReader",
                        "ReadableStream",
                        "ReadableByteStreamController",
                        "Range",
                        "RadioNodeList",
                        "RTCTrackEvent",
                        "RTCStatsReport",
                        "RTCSessionDescription",
                        "RTCSctpTransport",
                        "RTCRtpTransceiver",
                        "RTCRtpSender",
                        "RTCRtpReceiver",
                        "RTCPeerConnectionIceEvent",
                        "RTCPeerConnectionIceErrorEvent",
                        "RTCPeerConnection",
                        "RTCIceTransport",
                        "RTCIceCandidate",
                        "RTCErrorEvent",
                        "RTCError",
                        "RTCEncodedVideoFrame",
                        "RTCEncodedAudioFrame",
                        "RTCDtlsTransport",
                        "RTCDataChannelEvent",
                        "RTCDataChannel",
                        "RTCDTMFToneChangeEvent",
                        "RTCDTMFSender",
                        "RTCCertificate",
                        "PromiseRejectionEvent",
                        "ProgressEvent",
                        "Profiler",
                        "ProcessingInstruction",
                        "PopStateEvent",
                        "PointerEvent",
                        "PluginArray",
                        "Plugin",
                        "PictureInPictureWindow",
                        "PictureInPictureEvent",
                        "PeriodicWave",
                        "PerformanceTiming",
                        "PerformanceServerTiming",
                        "PerformanceResourceTiming",
                        "PerformancePaintTiming",
                        "PerformanceObserverEntryList",
                        "PerformanceObserver",
                        "PerformanceNavigationTiming",
                        "PerformanceNavigation",
                        "PerformanceMeasure",
                        "PerformanceMark",
                        "PerformanceLongTaskTiming",
                        "PerformanceEventTiming",
                        "PerformanceEntry",
                        "PerformanceElementTiming",
                        "Performance",
                        "Path2D",
                        "PannerNode",
                        "PageTransitionEvent",
                        "OverconstrainedError",
                        "OscillatorNode",
                        "OffscreenCanvasRenderingContext2D",
                        "OffscreenCanvas",
                        "OfflineAudioContext",
                        "OfflineAudioCompletionEvent",
                        "NodeList",
                        "NodeIterator",
                        "NodeFilter",
                        "Node",
                        "NetworkInformation",
                        "Navigator",
                        "NavigationTransition",
                        "NavigationHistoryEntry",
                        "NavigationDestination",
                        "NavigationCurrentEntryChangeEvent",
                        "Navigation",
                        "NavigateEvent",
                        "NamedNodeMap",
                        "MutationRecord",
                        "MutationObserver",
                        "MouseEvent",
                        "MimeTypeArray",
                        "MimeType",
                        "MessagePort",
                        "MessageEvent",
                        "MessageChannel",
                        "MediaStreamTrackProcessor",
                        "MediaStreamTrackGenerator",
                        "MediaStreamTrackEvent",
                        "MediaStreamTrack",
                        "MediaStreamEvent",
                        "MediaStreamAudioSourceNode",
                        "MediaStreamAudioDestinationNode",
                        "MediaStream",
                        "MediaSourceHandle",
                        "MediaSource",
                        "MediaRecorder",
                        "MediaQueryListEvent",
                        "MediaQueryList",
                        "MediaList",
                        "MediaError",
                        "MediaEncryptedEvent",
                        "MediaElementAudioSourceNode",
                        "MediaCapabilities",
                        "Location",
                        "LayoutShiftAttribution",
                        "LayoutShift",
                        "LargestContentfulPaint",
                        "KeyframeEffect",
                        "KeyboardEvent",
                        "IntersectionObserverEntry",
                        "IntersectionObserver",
                        "InputEvent",
                        "InputDeviceInfo",
                        "InputDeviceCapabilities",
                        "ImageData",
                        "ImageCapture",
                        "ImageBitmapRenderingContext",
                        "ImageBitmap",
                        "IdleDeadline",
                        "IIRFilterNode",
                        "IDBVersionChangeEvent",
                        "IDBTransaction",
                        "IDBRequest",
                        "IDBOpenDBRequest",
                        "IDBObjectStore",
                        "IDBKeyRange",
                        "IDBIndex",
                        "IDBFactory",
                        "IDBDatabase",
                        "IDBCursorWithValue",
                        "IDBCursor",
                        "History",
                        "Headers",
                        "HashChangeEvent",
                        "HTMLVideoElement",
                        "HTMLUnknownElement",
                        "HTMLUListElement",
                        "HTMLTrackElement",
                        "HTMLTitleElement",
                        "HTMLTimeElement",
                        "HTMLTextAreaElement",
                        "HTMLTemplateElement",
                        "HTMLTableSectionElement",
                        "HTMLTableRowElement",
                        "HTMLTableElement",
                        "HTMLTableColElement",
                        "HTMLTableCellElement",
                        "HTMLTableCaptionElement",
                        "HTMLStyleElement",
                        "HTMLSpanElement",
                        "HTMLSourceElement",
                        "HTMLSlotElement",
                        "HTMLSelectElement",
                        "HTMLScriptElement",
                        "HTMLQuoteElement",
                        "HTMLProgressElement",
                        "HTMLPreElement",
                        "HTMLPictureElement",
                        "HTMLParamElement",
                        "HTMLParagraphElement",
                        "HTMLOutputElement",
                        "HTMLOptionsCollection",
                        "HTMLOptionElement",
                        "HTMLOptGroupElement",
                        "HTMLObjectElement",
                        "HTMLOListElement",
                        "HTMLModElement",
                        "HTMLMeterElement",
                        "HTMLMetaElement",
                        "HTMLMenuElement",
                        "HTMLMediaElement",
                        "HTMLMarqueeElement",
                        "HTMLMapElement",
                        "HTMLLinkElement",
                        "HTMLLegendElement",
                        "HTMLLabelElement",
                        "HTMLLIElement",
                        "HTMLInputElement",
                        "HTMLImageElement",
                        "HTMLIFrameElement",
                        "HTMLHtmlElement",
                        "HTMLHeadingElement",
                        "HTMLHeadElement",
                        "HTMLHRElement",
                        "HTMLFrameSetElement",
                        "HTMLFrameElement",
                        "HTMLFormElement",
                        "HTMLFormControlsCollection",
                        "HTMLFontElement",
                        "HTMLFieldSetElement",
                        "HTMLEmbedElement",
                        "HTMLElement",
                        "HTMLDocument",
                        "HTMLDivElement",
                        "HTMLDirectoryElement",
                        "HTMLDialogElement",
                        "HTMLDetailsElement",
                        "HTMLDataListElement",
                        "HTMLDataElement",
                        "HTMLDListElement",
                        "HTMLCollection",
                        "HTMLCanvasElement",
                        "HTMLButtonElement",
                        "HTMLBodyElement",
                        "HTMLBaseElement",
                        "HTMLBRElement",
                        "HTMLAudioElement",
                        "HTMLAreaElement",
                        "HTMLAnchorElement",
                        "HTMLAllCollection",
                        "GeolocationPositionError",
                        "GeolocationPosition",
                        "GeolocationCoordinates",
                        "Geolocation",
                        "GamepadHapticActuator",
                        "GamepadEvent",
                        "GamepadButton",
                        "Gamepad",
                        "GainNode",
                        "FormDataEvent",
                        "FormData",
                        "FontFaceSetLoadEvent",
                        "FontFace",
                        "FocusEvent",
                        "FileReader",
                        "FileList",
                        "File",
                        "FeaturePolicy",
                        "External",
                        "EventTarget",
                        "EventSource",
                        "EventCounts",
                        "Event",
                        "ErrorEvent",
                        "ElementInternals",
                        "Element",
                        "DynamicsCompressorNode",
                        "DragEvent",
                        "DocumentType",
                        "DocumentFragment",
                        "Document",
                        "DelayNode",
                        "DecompressionStream",
                        "DataTransferItemList",
                        "DataTransferItem",
                        "DataTransfer",
                        "DOMTokenList",
                        "DOMStringMap",
                        "DOMStringList",
                        "DOMRectReadOnly",
                        "DOMRectList",
                        "DOMRect",
                        "DOMQuad",
                        "DOMPointReadOnly",
                        "DOMPoint",
                        "DOMParser",
                        "DOMMatrixReadOnly",
                        "DOMMatrix",
                        "DOMImplementation",
                        "DOMException",
                        "DOMError",
                        "CustomStateSet",
                        "CustomEvent",
                        "CustomElementRegistry",
                        "Crypto",
                        "CountQueuingStrategy",
                        "ConvolverNode",
                        "ConstantSourceNode",
                        "CompressionStream",
                        "CompositionEvent",
                        "Comment",
                        "CloseEvent",
                        "ClipboardEvent",
                        "CharacterData",
                        "ChannelSplitterNode",
                        "ChannelMergerNode",
                        "CanvasRenderingContext2D",
                        "CanvasPattern",
                        "CanvasGradient",
                        "CanvasCaptureMediaStreamTrack",
                        "CSSVariableReferenceValue",
                        "CSSUnparsedValue",
                        "CSSUnitValue",
                        "CSSTranslate",
                        "CSSTransformValue",
                        "CSSTransformComponent",
                        "CSSSupportsRule",
                        "CSSStyleValue",
                        "CSSStyleSheet",
                        "CSSStyleRule",
                        "CSSStyleDeclaration",
                        "CSSSkewY",
                        "CSSSkewX",
                        "CSSSkew",
                        "CSSScale",
                        "CSSRuleList",
                        "CSSRule",
                        "CSSRotate",
                        "CSSPropertyRule",
                        "CSSPositionValue",
                        "CSSPerspective",
                        "CSSPageRule",
                        "CSSNumericValue",
                        "CSSNumericArray",
                        "CSSNamespaceRule",
                        "CSSMediaRule",
                        "CSSMatrixComponent",
                        "CSSMathValue",
                        "CSSMathSum",
                        "CSSMathProduct",
                        "CSSMathNegate",
                        "CSSMathMin",
                        "CSSMathMax",
                        "CSSMathInvert",
                        "CSSMathClamp",
                        "CSSLayerStatementRule",
                        "CSSLayerBlockRule",
                        "CSSKeywordValue",
                        "CSSKeyframesRule",
                        "CSSKeyframeRule",
                        "CSSImportRule",
                        "CSSImageValue",
                        "CSSGroupingRule",
                        "CSSFontPaletteValuesRule",
                        "CSSFontFaceRule",
                        "CSSCounterStyleRule",
                        "CSSContainerRule",
                        "CSSConditionRule",
                        "CDATASection",
                        "ByteLengthQueuingStrategy",
                        "BroadcastChannel",
                        "BlobEvent",
                        "Blob",
                        "BiquadFilterNode",
                        "BeforeUnloadEvent",
                        "BeforeInstallPromptEvent",
                        "BaseAudioContext",
                        "BarProp",
                        "AudioWorkletNode",
                        "AudioSinkInfo",
                        "AudioScheduledSourceNode",
                        "AudioProcessingEvent",
                        "AudioParamMap",
                        "AudioParam",
                        "AudioNode",
                        "AudioListener",
                        "AudioDestinationNode",
                        "AudioContext",
                        "AudioBufferSourceNode",
                        "AudioBuffer",
                        "Attr",
                        "AnimationEvent",
                        "AnimationEffect",
                        "Animation",
                        "AnalyserNode",
                        "AbstractRange",
                        "AbortSignal",
                        "AbortController",
                        "Iterator",
                        "AbsoluteOrientationSensor",
                        "Accelerometer",
                        "AudioWorklet",
                        "BatteryManager",
                        "Cache",
                        "CacheStorage",
                        "Clipboard",
                        "ClipboardItem",
                        "CookieChangeEvent",
                        "CookieStore",
                        "CookieStoreManager",
                        "Credential",
                        "CredentialsContainer",
                        "CryptoKey",
                        "DeviceMotionEvent",
                        "DeviceMotionEventAcceleration",
                        "DeviceMotionEventRotationRate",
                        "DeviceOrientationEvent",
                        "FederatedCredential",
                        "GravitySensor",
                        "Gyroscope",
                        "Keyboard",
                        "KeyboardLayoutMap",
                        "LinearAccelerationSensor",
                        "Lock",
                        "LockManager",
                        "MIDIAccess",
                        "MIDIConnectionEvent",
                        "MIDIInput",
                        "MIDIInputMap",
                        "MIDIMessageEvent",
                        "MIDIOutput",
                        "MIDIOutputMap",
                        "MIDIPort",
                        "MediaDeviceInfo",
                        "MediaDevices",
                        "MediaKeyMessageEvent",
                        "MediaKeySession",
                        "MediaKeyStatusMap",
                        "MediaKeySystemAccess",
                        "MediaKeys",
                        "NavigationPreloadManager",
                        "NavigatorManagedData",
                        "OrientationSensor",
                        "PasswordCredential",
                        "RelativeOrientationSensor",
                        "Sanitizer",
                        "ScreenDetailed",
                        "ScreenDetails",
                        "Sensor",
                        "SensorErrorEvent",
                        "ServiceWorker",
                        "ServiceWorkerContainer",
                        "ServiceWorkerRegistration",
                        "StorageManager",
                        "SubtleCrypto",
                        "VirtualKeyboard",
                        "WebTransport",
                        "WebTransportBidirectionalStream",
                        "WebTransportDatagramDuplexStream",
                        "WebTransportError",
                        "Worklet",
                        "XRDOMOverlayState",
                        "XRLayer",
                        "XRWebGLBinding",
                        "AmbientLightSensor",
                        "Magnetometer",
                        "AudioData",
                        "EncodedAudioChunk",
                        "EncodedVideoChunk",
                        "ImageTrack",
                        "ImageTrackList",
                        "VideoColorSpace",
                        "VideoFrame",
                        "AudioDecoder",
                        "AudioEncoder",
                        "ImageDecoder",
                        "VideoDecoder",
                        "VideoEncoder",
                        "AuthenticatorAssertionResponse",
                        "AuthenticatorAttestationResponse",
                        "AuthenticatorResponse",
                        "PublicKeyCredential",
                        "BackForwardCacheRestoration",
                        "BarcodeDetector",
                        "Bluetooth",
                        "BluetoothCharacteristicProperties",
                        "BluetoothDevice",
                        "BluetoothRemoteGATTCharacteristic",
                        "BluetoothRemoteGATTDescriptor",
                        "BluetoothRemoteGATTServer",
                        "BluetoothRemoteGATTService",
                        "BluetoothAdvertisingEvent",
                        "BluetoothLEScan",
                        "BluetoothManufacturerDataMap",
                        "BluetoothServiceDataMap",
                        "CharacterBoundsUpdateEvent",
                        "EditContext",
                        "TextFormat",
                        "TextFormatUpdateEvent",
                        "TextUpdateEvent",
                        "ContactAddress",
                        "ContactsManager",
                        "DevicePosture",
                        "FaceDetector",
                        "FileSystemDirectoryHandle",
                        "FileSystemFileHandle",
                        "FileSystemHandle",
                        "FileSystemWritableFileStream",
                        "FragmentDirective",
                        "GPU",
                        "GPUAdapter",
                        "GPUAdapterInfo",
                        "GPUBindGroup",
                        "GPUBindGroupLayout",
                        "GPUBuffer",
                        "GPUCanvasContext",
                        "GPUCommandBuffer",
                        "GPUCommandEncoder",
                        "GPUCompilationInfo",
                        "GPUCompilationMessage",
                        "GPUComputePassEncoder",
                        "GPUComputePipeline",
                        "GPUDevice",
                        "GPUDeviceLostInfo",
                        "GPUError",
                        "GPUExternalTexture",
                        "GPUInternalError",
                        "GPUOutOfMemoryError",
                        "GPUPipelineError",
                        "GPUPipelineLayout",
                        "GPUQuerySet",
                        "GPUQueue",
                        "GPURenderBundle",
                        "GPURenderBundleEncoder",
                        "GPURenderPassEncoder",
                        "GPURenderPipeline",
                        "GPUSampler",
                        "GPUShaderModule",
                        "GPUSupportedFeatures",
                        "GPUSupportedLimits",
                        "GPUTexture",
                        "GPUTextureView",
                        "GPUUncapturedErrorEvent",
                        "GPUValidationError",
                        "WGSLLanguageFeatures",
                        "GamepadTouch",
                        "HandwritingStroke",
                        "IdentityCredential",
                        "IdentityProvider",
                        "IdleDetector",
                        "LaunchParams",
                        "LaunchQueue",
                        "MLContext",
                        "MerchantValidationEvent",
                        "NDEFMessage",
                        "NDEFReader",
                        "NDEFReadingEvent",
                        "NDEFRecord",
                        "OTPCredential",
                        "PaymentAddress",
                        "PaymentRequest",
                        "PaymentResponse",
                        "PaymentMethodChangeEvent",
                        "PerformanceLongAnimationFrameTiming",
                        "PerformanceScriptTiming",
                        "Presentation",
                        "PresentationAvailability",
                        "PresentationConnection",
                        "PresentationConnectionAvailableEvent",
                        "PresentationConnectionCloseEvent",
                        "PresentationConnectionList",
                        "PresentationReceiver",
                        "PresentationRequest",
                        "PressureObserver",
                        "PressureRecord",
                        "PrivateAttribution",
                        "SoftNavigationEntry",
                        "StorageBucket",
                        "StorageBucketManager",
                        "TextDetector",
                        "TimestampTrigger",
                        "ToggleEvent",
                        "USB",
                        "USBAlternateInterface",
                        "USBConfiguration",
                        "USBConnectionEvent",
                        "USBDevice",
                        "USBEndpoint",
                        "USBInTransferResult",
                        "USBInterface",
                        "USBIsochronousInTransferPacket",
                        "USBIsochronousInTransferResult",
                        "USBIsochronousOutTransferPacket",
                        "USBIsochronousOutTransferResult",
                        "USBOutTransferResult",
                        "WakeLock",
                        "WakeLockSentinel",
                        "XRAnchor",
                        "XRAnchorSet",
                        "XRBoundedReferenceSpace",
                        "XRCPUDepthInformation",
                        "XRCamera",
                        "XRDepthInformation",
                        "XRFrame",
                        "XRHitTestResult",
                        "XRHitTestSource",
                        "XRInputSource",
                        "XRInputSourceArray",
                        "XRInputSourceEvent",
                        "XRInputSourcesChangeEvent",
                        "XRLightEstimate",
                        "XRLightProbe",
                        "XRPose",
                        "XRRay",
                        "XRReferenceSpace",
                        "XRReferenceSpaceEvent",
                        "XRRenderState",
                        "XRRigidTransform",
                        "XRSession",
                        "XRSessionEvent",
                        "XRSpace",
                        "XRSystem",
                        "XRTransientInputHitTestResult",
                        "XRTransientInputHitTestSource",
                        "XRView",
                        "XRViewerPose",
                        "XRViewport",
                        "XRWebGLDepthInformation",
                        "XRWebGLLayer",
                        "XRCompositionLayer",
                        "XRProjectionLayer",
                        "XRSubImage",
                        "XRWebGLSubImage",
                        "XRHand",
                        "XRJointPose",
                        "XRJointSpace",
                        "XRImageTrackingResult",
                        "XRPlane",
                        "XRPlaneSet",
                        "SharedArrayBuffer",
                        "n.getGamepads",
                        "n.javaEnabled",
                        "n.sendBeacon",
                        "n.vibrate",
                        "n.canShare",
                        "n.share",
                        "n.clearAppBadge",
                        "n.getBattery",
                        "n.getUserMedia",
                        "n.requestMIDIAccess",
                        "n.requestMediaKeySystemAccess",
                        "n.setAppBadge",
                        "n.webkitGetUserMedia",
                        "n.createHandwritingRecognizer",
                        "n.queryHandwritingRecognizer",
                        "n.getEnvironmentIntegrity",
                        "n.getInstalledRelatedApps",
                        "d.adoptNode",
                        "d.append",
                        "d.captureEvents",
                        "d.caretRangeFromPoint",
                        "d.clear",
                        "d.close",
                        "d.createAttribute",
                        "d.createAttributeNS",
                        "d.createCDATASection",
                        "d.createComment",
                        "d.createDocumentFragment",
                        "d.createElement",
                        "d.createElementNS",
                        "d.createEvent",
                        "d.createExpression",
                        "d.createNSResolver",
                        "d.createNodeIterator",
                        "d.createProcessingInstruction",
                        "d.createRange",
                        "d.createTextNode",
                        "d.createTreeWalker",
                        "d.elementFromPoint",
                        "d.elementsFromPoint",
                        "d.evaluate",
                        "d.execCommand",
                        "d.exitFullscreen",
                        "d.exitPictureInPicture",
                        "d.exitPointerLock",
                        "d.getElementById",
                        "d.getElementsByClassName",
                        "d.getElementsByName",
                        "d.getElementsByTagName",
                        "d.getElementsByTagNameNS",
                        "d.getSelection",
                        "d.hasFocus",
                        "d.importNode",
                        "d.open",
                        "d.prepend",
                        "d.queryCommandEnabled",
                        "d.queryCommandIndeterm",
                        "d.queryCommandState",
                        "d.queryCommandSupported",
                        "d.queryCommandValue",
                        "d.querySelector",
                        "d.querySelectorAll",
                        "d.releaseEvents",
                        "d.replaceChildren",
                        "d.webkitCancelFullScreen",
                        "d.webkitExitFullscreen",
                        "d.write",
                        "d.writeln",
                        "d.getAnimations",
                        "d.getPartRoot",
                        "d.hasStorageAccess",
                        "d.requestStorageAccess",
                        "d.startViewTransition",
                        "d.hasPrivateToken",
                        "d.hasRedemptionRecord",
                        "d.appendChild",
                        "d.cloneNode",
                        "d.compareDocumentPosition",
                        "d.contains",
                        "d.getRootNode",
                        "d.hasChildNodes",
                        "d.insertBefore",
                        "d.isDefaultNamespace",
                        "d.isEqualNode",
                        "d.isSameNode",
                        "d.lookupNamespaceURI",
                        "d.lookupPrefix",
                        "d.normalize",
                        "d.removeChild",
                        "d.replaceChild",
                        "d.addEventListener",
                        "d.dispatchEvent",
                        "d.removeEventListener",
                        "s.addEventListener",
                        "s.dispatchEvent",
                        "s.removeEventListener",
                        "so.lock",
                        "so.unlock",
                        "so.addEventListener",
                        "so.dispatchEvent",
                        "so.removeEventListener",
                        "o.onerror",
                        "o.onunhandledrejection",
                        "o.Array",
                    ],
                    "D": ["Array"],
                    "Infinity": ["Infinity"],
                    "NaN": ["NaN"],
                    "u": ["undefined", "event", "o.frameElement"],
                    "Google Inc.": ["n.vendor"],
                    "Mozilla": ["n.appCodeName"],
                    "Netscape": ["n.appName"],
                    user_agent: [
                        "n.appVersion"
                    ],
                    "Linux armv81": ["n.platform"],
                    "Gecko": ["n.product"],
                    user_agent: [
                        "n.userAgent"
                    ],
                    "es-US": ["n.language"],
                    "es-US,es-419,es": ["n.languages"],
                    "about:blank": ["d.URL", "d.documentURI"],
                    "BackCompat": ["d.compatMode"],
                    "UTF-8": ["d.characterSet", "d.charset", "d.inputEncoding"],
                    "text/html": ["d.contentType"],
                    "challenges.cloudflare.com": ["d.domain"],
                    f"https://challenges.cloudflare.com/cdn-cgi/challenge-platform/h/b/turnstile/if/ov2/av0/rcv0/0/3mgt0/{siteKey}/dark/fbE/normal/auto/": [
                        "d.referrer",
                        "d.baseURI",
                    ],
                    "s": ["d.cookie"],
                    datetime.now().strftime("%m/%d/%Y %H:%M:%S"): ["d.lastModified"],
                    "complete": ["d.readyState"],
                    "off": ["d.designMode"],
                    "hidden": ["d.visibilityState", "d.webkitVisibilityState"],
                    "": ["d.adoptedStyleSheets", "o.FnNf4"],
                    "#document": ["d.nodeName"],
                    "portrait-primary": ["so.type"],
                    "-17": ["o.BuTN0"],
                },
                "KHJm8": {"nYYcc7": False},
            },
            "2": {
                "bXDBI2": "Em1rwq/DicKsw6JH",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": random.randint(2200, 3500),
                "ErFO3": 3,
                "CnwZO6": "MG0KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zFEZmIFo1UBNNGjEnWTJVFUdtCg0QDmJIRHcwJR8DfXMURmYgWjVQE00aMSdZMlUVR20KDRAOYkhEdzAlHwN9cxRGZiBaNVATTRoxJ1kyVRVHbQoNEA5iSER3MCUfA31zZQ==",
            },
            "3": {
                "bXDBI2": "F2A8wqrDjsKtwrRL",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 61,
                "ErFO3": 3,
                "eQFj1": "2",
                "tbVpx1": ["lang", "dir"],
                "lIkZ4": [],
                "lsaFv5": False,
            },
            "4": {
                "bXDBI2": "ETA9w73CmMKlw6RC",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 300,
                "ErFO3": 3,
                "fuFr6": 0,
                "GuYvt7": -296,
                "SqXnv6": -300,
                "fKJe1": -300,
                "mLUc0": -300,
                "lqdnV2": 300,
                "Usyu7": 300,
                "mVJuq2": "America/Bogota",
            },
            "5": {
                "bXDBI2": "ETI6w7/CmsOww6VD",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 161,
                "ErFO3": 3,
                "yUZf7": repeat_func(True, c=65),
                "Rdysv2": True,
                "oIYNY3": 117,
                "CtOMU6": True,
                "NuAWK3": "a",
                "gedXF8": "undefined",
                "CEBtk4": "undefined",
                "fxjf2": "object",
                "SLsb5": "object",
                "ULdN0": "undefined",
                "TQPhi7": False,
                "esyTG0": "undefined",
                "yqmAa3": True,
                "pCvgH6": 13,
                "Fqcb6": 0,
                "LFRuP7": 1,
                "dZZWQ6": True,
                "UCcI4": False,
                "uKran5": -1,
                "gSZG6": -1,
                "vfZDg8": "[object Undefined]",
            },
            "6": {
                "bXDBI2": "FGw+wqrCmMKkw6RK",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 651,
                "ErFO3": 3,
                "FIFSS1": random.randint(50, 100),
            },
            "7": {
                "bXDBI2": "RDU6w7rDicO3w6VA",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 829,
                "ErFO3": 3,
                "WBku3": True,
                "RYCp6": False,
                "lTIFh4": False,
                "LZWN2": False,
                "bTAO7": True,
                "piIs0": False,
                "roikM7": 0.6,
                "pSZUM3": -1,
                "MJuj2": 7727,
            },
            "8": {
                "bXDBI2": "RW1swq/CnsO0wrNE",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 2346,
                "ErFO3": 3,
                "btqR5": "6913fa7edb21f1998ecf0f5421eef1adcf950f3fd395213c324039c4fda1cd32",
            },
            "9": {
                "bXDBI2": "QmY9wqvCmcO0w6dE",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 877,
                "ErFO3": 3,
                "NxGo7": "aacef12a4391d4e11dbf3f7819944fc92ef9936b548c0fd31af5b887254c7a00",
            },
            "10": {
                "bXDBI2": "QDA4wqnCmcOww6kR",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 16330,
                "ErFO3": 3,
                "QyECW7": "status_400",
            },
            "11": {
                "bXDBI2": "Qm0/wqPCm8KmwrdL",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 6676,
                "ErFO3": 3,
                "CnwZO6": "MG0UAT0+" # big token
            },
            "12": {
                "bXDBI2": "RWM3wqzCncKmw6cT",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 10,
                "ErFO3": 3,
                "QyECW7": "yes",
            },
            "13": {
                "bXDBI2": "FGJtw73CmsKjw6lE",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 24,
                "ErFO3": 3,
                "hxDhr5": "/div[1]/div[1]/div[1]/div[1]/div[1]",
                "LyMO3": "htm_la_di>hea>tit>-tmet_ht_co>met_ht_co>met_na_co>met_na_co>sty>-tmet_ht_co>scr_sr>sty>-tscr_sr_as_de_cr>bod_cl>div_cl_ro>div_cl>h1_cl>",
                "CnUW7": 4,
                "bHiof5": 2,
                "NQbg4": 5,
                "ZEZUx0": 2431941447,
                "dmbF6": 43,
                "AiWH8": domain if domain.split('/') > 3 else domain.split('/')[2],
                "uFTL1": True,
            },
            "14": {
                "bXDBI2": "FjE4wqPCncOxwrUT",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 433,
                "ErFO3": 3,
                "hyeG7": CF_CHALLENGE_LANG[1],
                "CSsW0": CF_CHALLENGE_LANG[2],
                "Xeobx7": CF_CHALLENGE_LANG[3],
                "fLWRO2": CF_CHALLENGE_LANG[4],
                "PloT7": "diciembre, hora estándar de Colombia",
                "ycPH4": "eo (Ucrania)",
                "XLaQ2": "Bippity-boppity, Mumbo-jumbo u hocuspocus",
                "NDoTn8": "21,000 billones",
            },
            "15": {
                "bXDBI2": "FzI7wqzDi8Ozw6JA",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 129,
                "ErFO3": 3,
                "MZnx7": [
                    {"t": "n", "i": "navigate"},
                    {"t": "v", "s": 0, "d": 0},
                    {"t": "lf"},
                    {
                        "t": "r",
                        "dlt": random.uniform(100, 500),
                        "i": "link",
                        "n": "https://challenges.cloudflare.com/cdn-cgi/challenge-platform/h/b/cmg/1/mSs%2F5lONlz8yLyl1SkqCnQaENIORJgsjDO0OHJ35zaA%3D",
                        "nh": "h3",
                        "ts": 361,
                        "bs": 61,
                    },
                    {
                        "t": "r",
                        "dlt": random.uniform(100, 500),
                        "i": "script",
                        "n": f"https://challenges.cloudflare.com/cdn-cgi/challenge-platform/h/b/orchestrate/chl_api/v1?ray={cf_ray}&lang=auto",
                        "nh": "h3",
                        "ts": 49303,
                        "bs": 49003,
                    },
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "p", "i": "first-paint"},
                    {"t": "lf"},
                    {"t": "p", "i": "first-contentful-paint"},
                    {
                        "t": "r",
                        "dlt": random.uniform(400, 1000),
                        "i": "xmlhttprequest",
                        "n": flow_url,
                        "nh": "h3",
                        "ts": 116559,
                        "bs": 116259,
                    },
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "v", "s": random.uniform(1000, 4600), "d": 0},
                    {"t": "v", "s": random.uniform(9500, 17000), "d": 0},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "v", "s": random.uniform(10000, 30000), "d": 0},
                    {"t": "v", "s": random.uniform(20000, 50000), "d": 0},
                    {"t": "lf"},
                    {"t": "lf"},
                    {"t": "m", "n": "cp-n-86252"},
                ],
            },
            "16": {
                "bXDBI2": "QjJswq/DjcKkw6NF",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 2986,
                "ErFO3": 3,
                "CnwZO6": "MDR6PwwWIFxKbxlGHQ0DBw9GDkNkBgN6CExBShI8MFY7KGBuQ3oEDwoeCxBWAikzfygWHB9BDWAVT1JECh9GcB8+KgVOemlILzoNAxowbBhWBxpBGyoMUAZRDQdEDQtZSxs9LxE2PAYHMgsBBXxufRoMeRJ/BVkTWxoiKHcoIRdDBjUtHjE9Cxw8DQpWASkyUApbDVwECFQSFEM2XxMBRT0deB4WPyYPSBInXEVnfn0YK0QEXSQtESRrQ1UeVk0VFjJ0bkBuZlhbM1ZcF2EqN1wFVlNXAlcJVgpXBQYABQMNfjt1CC0HHCxhQEhUbHpkCldSVQsCVVcHXAIEAgAFAVN4angabjcLXDNTB08kOQVOIABDbg==",
            },
            "17": {
                "bXDBI2": "FGU8w77CnMOwwrVL",
                "kOrNV4": "VWbRKP0BOyfvQET",
                "skgtQ6": "",
                "qLTl5": 472,
                "ErFO3": 3,
                "FoAuB0": 95,
                "wNgO1": 100,
            },
            "18": {
                "bXDBI2": "RW1rw77Di8Kjw6JD",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 18,
                "ErFO3": 3,
                "QyECW7": "yes",
            },
            "19": {
                "bXDBI2": "Fjc3wqnCkcOxw6FC",
                "kOrNV4": "yes",
                "skgtQ6": "",
                "qLTl5": 205,
                "ErFO3": 3,
                "UULaO4": True,
                "HjlOp4": [
                    "af51ag",
                    "554c3a",
                    "f5d0cc8",
                    "af51ag",
                    "554c3a",
                    "f5d0cc8",
                    "af51ag",
                    "554c3a",
                    "f5d0cc8",
                    "af51ag",
                    "554c3a",
                    "f5d0cc8",
                    "af51ag",
                    "554c3a",
                    "f5d0cc8",
                    "af51ag",
                    "554c3a",
                    "f5d0cc8",
                ],
            },
            "Iotan0": "chl_api_m",
            "cxlU8": "86252",
            "ZNpH4": cf_ray,
            "OfLv3": "3",
            "kipPH4": 19,
            "LxrEk8": "0",
            "kAUw0": random.uniform(100, 400),
            "lETW7": random.uniform(100, 500),
            "ZhtLK5": {
                "ru": params[27].split("'")[1],
                "ra": params[28].split("'")[1],
                "d": params[29].split("'")[1],
                "t": params[30].split("'")[1],
                "m": params[31].split("'")[1],
                "i1": params[32].split("'")[1],
                "i2": params[33].split("'")[1],
                "uh": params[34].split("'")[1],
                "hh": params[35].split("'")[1],
                "zh": params[36].split("'")[1],
            },
            "PZKL0": {
                "dYjR8": 0,
                "QEey2": 0,
                "pARx5": 0,
                "wDQcp4": 0,
                "LkpZG2": 0,
                "dhbx1": 0,
                "wZkEO6": 0,
                "LLtC8": 0,
            },
            "nbVnE1": 1,
            "VXEb2": "0",
            "ESpj2": siteKey,
            "qBkvc8": "interactive",
            "wETrQ4": cf_ray,
            "NrYV5": "3gAFo2l2Mbg2ekUvVWRzVkZtZVR1UXFsTzcwdzdRPT2jaXYyuDN5RXBQQXNwV2NCWmlvUGtqR2lkT3c9PaFk2gGYTWtWVGhuR0liT2dSVlFRV3JlaWw0WlRIWW5ZWGZHZ0RMVDNsZXZxako3Z0pudDAzeWE1UzdKOGJxV2F2ZjcwbjVNQ0JyNVRseWhJdnJkSU4rYjJwUjBuQUhLU2lHOGxNbHRseHREUzFjN01PbllLVmVobUs1NTdPeEVhRmtKQ1plNlZYQ3BLTmN2bVhUNER3MEloaVJmdGRVL2Y1cFhiSGxtUiszaHFvNkF2cUJCMmhVTloxTURCcnQrVTg0N3JXWXpMdmNoTDYrTTN1VGpGUkxET1dXbjBLblhFZHBpYi96V2o0RzB4MUJIcTNtMlJQWkdYMFNEV1hwdjA5RXByTUV1Ui93T3BqNElUMUtEU1QrTms3eFRhZmhUSFlYbitZREc3cGYzSTNFQWt2RWV1ZExleXdDWVhRS3JvU3ArK1RsMmJLUHlVUGpKd2hqbDNQNWR0bC9nd2tPY2UwSkJ0ZHBPWUU2U3lIRUJCcEg2c080MkRjQ3FZWXVIdStxN0xtZXlpNFJkRGZtVDRVVWhZNklaajdqUT09oW3ZLGRWZ1gxSUNxYjNwbEQvazdncDlIV09mMUFFOXVJZmlhRStwTTRPUmhVdTQ9oXS0TVRjeU9USTNNalF5TVM0ek5EZz0=",
            "RnkWM0": 0,
            "goWbN7": is_this_a_key,
            "OKUJ7": f"https://challenges.cloudflare.com/turnstile/v0/b/{is_this_a_key}/api.js?onload=DXjyL6&render=explicit",
            "MBlJ0": domain if domain.split('/') > 3 else domain.split('/')[2],
            "wueX2": domain if not domain.split('/') > 3 else domain.split('/')[2],
            "itebZ1": params[10].split("'")[1],
            "cZmt6": random.uniform(2000, 5000),
            "RMiRU4": random.uniform(2000, 5000),
            "svKw7": 0,
            "jgvf6": 0,
            "rsZM5": random.uniform(2000, 4000),
            "tjTLZ1": 0,
            "cobF5": random.uniform(2, 30),
            "huON7": random.uniform(100, 600),
            "jASY4": random.uniform(100, 500),
            "fmoBu7": random.uniform(10, 100),
            "cXwwl8": {
                "d": params[29].split("'")[1],
                "t": params[30].split("'")[1],
                "m": params[31].split("'")[1],
                "i1": params[32].split("'")[1],
                "i2": params[33].split("'")[1],
                "zh": params[36].split("'")[1],
            },
            "coao1": ass_param,
            "bacv6": "MCEtIBV0cQkEOhEBEndgcwQGWwVKXT1fXRcBCVQdWhVHbQQiW3RnRlx5UVMr",
            "deQGd3": "blob:https://challenges.cloudflare.com/b173b715-ecd0-4c79-ad10-e63797226e5b",
            "YTdt0": {},
            "FnLS7": [],
            "QZBQ4": "0XXeD30SLmitocp8hjjDw62A9fjYuhAAVcsHknbM2go",
            "YGlLG1": "Ef0REg_gVIthnAp",
            "jDTe4": 1,
            "FnNf4": repeat_func(c=5),
            "MEuBS5": 0,
        }

    def cf4_manage_data(params):
        return {
            "xNpd8": "managed",
            "Hskjy2": "3",
            "FqEs8": 0,
            "BMZf3": 0,
            "HnLs7": random.uniform(100, 300),
            "TjUO3": random.uniform(20, 100),
            "cfwI0": 1,
            "WaXp8": round(time.time()),
            "MCtdU7": params[45].split('"')[1],
            "fTbv6": {
                "FtEcH8": 0,
                "CbtNe8": 0,
                "BDJXd0": 0,
                "ggshp5": 0,
                "RLjrX1": 0,
                "RIuu2": 0,
                "XVGU4": 0,
                "DOJu7": 0
            },
            "oeCA8": False,
            "UtEyu3": False,
            "GadVZ5": "bGYfe3",
            "WVBSW0": "",
            "ffXus1": repeat_func(c=5),
            "nWlT8": 0,
            "kAWb2": "OjNxS4"
        }

if __name__ == '__main__':
    a, b, r = parse_cf_params('https://nopecha.com/demo/cloudflare', key)
    for i,v in enumerate(a):
        print(i, v)

    print(CF_Interactive.cf4_manage_data(a))
